﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="CloudFieldStatistics.ascx.cs" Inherits="Coveo.SearchProvider.Applications.Admin.Controls.CloudFieldStatistics" %>
<%@ Register tagPrefix="coveo" tagName="UsageValue" src="UsageValue.ascx" %>

<asp:PlaceHolder ID="WarningPanel" runat="server">
    <div class="info-panel">
        <asp:Label ID="WarningMessageLabel" runat="server"/>
    </div>
</asp:PlaceHolder>

<table cellspacing="0" class="coveo-stats">
    <thead>
        <tr>
            <th>&nbsp;</th>
            <th>Instance</th>
            <th>Organization</th>
            <th>Limit</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <th>Count (Usage)</th>
            <td>
                <asp:Label ID="NumberOfInstanceFieldsLabel" runat="server"/>
                (<coveo:UsageValue ID="InstanceOverLimitUsage"
                                   UsageDescription="Instance fields compared to maximum number of fields"
                                   runat="server"/>)
            </td>
            <td>
                <asp:Label ID="NumberOfOrganizationFieldsLabel" runat="server"/>
                (<coveo:UsageValue ID="OrganizationOverLimitUsage"
                                   CheckThreshold="true"
                                   UsageDescription="Organization fields compared to maximum number of fields"
                                   runat="server"/>)
            </td>
            <td>
                <asp:Label ID="MaximumNumberOfOrganizationFieldsLabel" runat="server"/>
            </td>
        </tr>
    </tbody>
</table>